using Toybox.Application.Properties;
import Toybox.Application.Storage;

import Toybox.Lang;

module P
{

function type(v)
{

    if (v instanceof Number) {
        return Number; }
    else if (v instanceof Long) {
        return Long; }
    else if (v instanceof Float) {
        return Float; }
    else if (v instanceof Double) {
        return Double; }
    else if (v instanceof Boolean) {
        return Boolean; }
    else if (v instanceof String) {
        return String; }
    else if (v instanceof Array) {
        return Array; }
    else if (v instanceof Dictionary) {
        return Dictionary; }
    return null;
}

public function get_prop(key, def)
{
    var v;

    try {
        v = Properties.getValue(key);
    } catch (e) {
        v = null;
    }

    if (def == null) {
        return v; }

    if (v instanceof type(def) && v != null) {
        return v; }
    return def;
}

public function set_prop(key, value)
{

    Properties.setValue(key, value);
}

public function get_store(key, def)
{

    var v = Storage.getValue(key);
    if (def == null) {
        return v; }

    if (v instanceof type(def) && v != null) {
        return v; }

    return def;
}

public function set_store(key, value)
{

    Storage.setValue(key, value);
}

}
