import Toybox.Graphics;
import Toybox.Lang;
import Toybox.System;
import Toybox.Timer;
import Toybox.WatchUi;

class Onoff extends WatchUi.View
{

private var dev as Dictionary;
private var name;
private var msg as String or Null;

private var need_state;

function initialize(idx)
{

    //L.dbg_log(L.DBG_LIFE, "Onoff.initialize()");
    View.initialize();

    dev = C.outlets[idx];
    name = dev["name"];
    msg = null;
    C.onoff_state = dev["state"];
    C.onoff_ood = dev["ood"];
    need_state = true;
}

// Load your resources here
function onLayout(dc as Dc) as Void
{

    //L.dbg_log(L.DBG_LIFE, "Onoff.onLayout()");
}

// Called when this View is brought to the foreground. Restore
// the state of this View and prepare it to be shown. This includes
// loading resources into memory.
function onShow() as Void
{

    //L.dbg_log(L.DBG_LIFE, "Onoff.onShow():" + need_state);
    if (need_state) {
        C.sh_progress(name + "\nget state", new ProgressDelegate());
        C.dev_ctrl(C.CTRL_GET, dev, 0, method(:got_state));
    }
}

// Update the view
function onUpdate(dc as Dc) as Void
{
    var sh_txt;

    //L.dbg_log(L.DBG_LIFE, "Onoff.onUpdate()");

//L.log(name + " => " + C.onoff_state);
    var bitm = WatchUi.loadResource(G.get_icon(dev["icon"], C.onoff_state, C.icons));
    var off = bitm.getWidth()/2;
    var bm_xy = C.radius - off;
    var txt_y = bm_xy - dc.getFontHeight(Graphics.FONT_MEDIUM);

    dc.setColor(G.WHITE, G.BLACK);
    dc.clear();

    sh_txt = name;
    var info = dev["info"] as Dictionary;
    var t = info["cur_temp"];
    var tt = info["target_temp"];
    if (C.settings["temp_unit"] == 0) {
        t = C.c2f(t);
        if (tt != null) {
            tt = (tt == 0) ? null : C.c2f(tt); }
    }
    if (!C.onoff_ood && (t != null)) {
        sh_txt += "-" + t; }
    dc.drawText(C.cx, txt_y, Graphics.FONT_MEDIUM, sh_txt, Graphics.TEXT_JUSTIFY_CENTER);

    if (C.onoff_ood) {
        dc.drawBitmap(bm_xy, bm_xy, WatchUi.loadResource(G.get_ood(C.radius))); }
    dc.drawBitmap(bm_xy, bm_xy, bitm);

    txt_y = C.radius + off;
    sh_txt = (msg == null) ? dev_type(dev["type"]) : msg;
    if (tt != null) {
        sh_txt += "-" + tt; }
    dc.drawText(C.cx, txt_y, Graphics.FONT_TINY, sh_txt, Graphics.TEXT_JUSTIFY_CENTER);
}

// Called when this View is removed from the screen. Save the
// state of this View here. This includes freeing resources from
// memory.
function onHide() as Void
{

    //L.dbg_log(L.DBG_LIFE, "Onoff.onHide()");
}

function dev_type(type)
{

    switch (type) {

    case C.OUTLET_TPLINK:
        return "TpLink";

    case C.OUTLET_SHELLY:
        return "Shelly";

    case C.OUTLET_ATHOME:
        return "AtHome";

    case C.OUTLET_HUUM:
        return "Huum";

    }
    return "??";
}

function got_state(state, msg)
{

    //L.dbg_log(L.DBG_LIFE, "got_state:" + state);
    me.msg = msg;
    if (msg == null) {
        C.onoff_ood = false;
        if (state != G.STATE_UNK) {
            C.onoff_state = state; }
    } else {
        C.onoff_state = G.STATE_OFL;
        C.onoff_ood = true; }
    need_state = false;

    dev["state"] = C.onoff_state;
    dev["ood"] = C.onoff_ood;
    C.save_devs(dev);

    new Timer.Timer().start(method(:pop_view), 50, false);
}

function pop_view() as Void
{

    WatchUi.popView(WatchUi.SLIDE_IMMEDIATE);
}

}

class ProgressDelegate extends WatchUi.BehaviorDelegate
{

function initialize()
{

    BehaviorDelegate.initialize();
    //L.dbg_log(L.DBG_LIFE, "PB.iniitialize()");
}

function onBack()
{

    //L.dbg_log(L.DBG_LIFE, "PB.iniitialize()");
    return true;
}

}

class OnoffDelegate extends WatchUi.BehaviorDelegate
{

private var dev as Dictionary;
private var name;

function initialize(idx)
{

    //L.dbg_log(L.DBG_LIFE, "OnoffDelegate.initialize()");
    BehaviorDelegate.initialize();

    dev = C.outlets[idx];
    name = dev["name"];
}

function onNextPage() as Boolean
{

    //L.dbg_log(L.DBG_LIFE, "OnoffDelegate.onNextPage()");
    return true;
}

function onPreviousPage() as Boolean
{

    //L.dbg_log(L.DBG_LIFE, "OnoffDelegate.onPreviousPage()");
    return true;
}

function onMenu() as Boolean
{

    //L.dbg_log(L.DBG_LIFE, "OnoffDelegate.onMenu()");
    return true;
}

function onSelect() as Boolean
{

    //L.dbg_log(L.DBG_LIFE, "OnoffDelegate.onSelect():" + idx);

    var new_state = (C.onoff_state == G.STATE_ON)? G.STATE_OFF : G.STATE_ON;
    C.sh_progress(name +"\n" + (new_state ? "on" : "off"), new ProgressDelegate());
    C.dev_ctrl(C.CTRL_SET, dev, new_state, method(:new_state));

    return true;
}

public function new_state(state, msg)
{

    //L.dbg_log(L.DBG_LIFE, "OnoffDelegate.new_state:" + state + ", " + msg);
    if (msg == null) {
        C.onoff_ood = false;
        if (state != G.STATE_UNK) {
            C.onoff_state = state; }
    } else {
        C.onoff_ood = true; }

    dev["state"] = C.onoff_state;
    dev["ood"] = C.onoff_ood;
    C.save_devs(dev);

    new Timer.Timer().start(method(:pop_view), 50, false);
}

function pop_view() as Void
{

    WatchUi.popView(WatchUi.SLIDE_IMMEDIATE);
}

}
