import Toybox.Application;
import Toybox.Graphics;
import Toybox.Lang;
import Toybox.WatchUi;

class FlickView extends WatchUi.View
{

function initialize()
{

    L.dbg_log(L.DBG_LIFE, "FlickView.initialize()");

    View.initialize();
    C.get_settings();
    if (C.load_devs()) {
        C.set_alert(null, null);
        C.state = C.MAIN_SHOW;
    } else {
        C.set_alert("Tap to scan", "(" + L.version + ")");
        C.state = C.MAIN_WAIT;
    }
}

// Load your resources here
function onLayout(dc as Dc) as Void
{

    L.dbg_log(L.DBG_LIFE, "FlickView.onLayout()");

    C.cx = dc.getWidth() / 2;
    C.cy = dc.getHeight() / 2;
    C.radius = (C.cx > C.cy) ? C.cy : C.cx;
    C.icons = (C.radius < 150) ? C.icons_med : C.icons_lg;
    L.dbg_log(L.DBG_LIFE, "radius:" + C.radius);
}

// Called when this View is brought to the foreground. Restore
// the state of this View and prepare it to be shown. This includes
// loading resources into memory.
function onShow() as Void
{

    L.dbg_log(L.DBG_LIFE, "FlickView.onShow:" + C.state);

    switch (C.state) {

    case C.MAIN_SCAN:
        C.set_alert("Wait internet", "");
        break;

    case C.MAIN_WAIT:
        C.set_alert("Tap to scan", "(" + L.version + ")");
        break;

    case C.MAIN_ENUMERATE:
        C.set_alert(null, null);
        break;

    case C.MAIN_SHOW:
        if (C.outlets.size() <= 0) {
            C.set_alert("Tap to scan", "(" + L.version + ")");
            C.state = C.MAIN_WAIT;
        } else {
            sh_devs(); }
        break;

    case C.MAIN_ERROR:
        break;

    }
    if (C.state != C.MAIN_SHOW) {
        C.outlets = new [0]; }
    C.tplink = new Tplink();
    C.shelly = new Shelly();
    C.athome = new AtHome();
    C.huum = new Huum();
    C.enumerating = C.OUTLET_TPLINK;
    if (C.state == C.MAIN_SCAN) {
        enumerate(C.enumerating, null); }
}

// Update the view
function onUpdate(dc as Dc) as Void
{

    //L.dbg_log(L.DBG_LIFE, "FlickView.onUpdate:" + C.state);
    if (C.state == C.MAIN_ENUMERATE) {
        C.state = C.MAIN_SCAN;
        C.set_alert("Wait internet", "");
        enumerate(C.enumerating, null);
    }

    if (C.state == C.MAIN_LOG) {
        L.log("sh_log:");
        WatchUi.pushView(new LogMenu(), new LogDelegate(), WatchUi.SLIDE_UP);
    } else {
        if (C.alert_hdr != null) {
            dc.setColor(C.WHITE, C.BLACK);
            dc.clear();
            var msg = C.alert_hdr + "\n" + C.alert_body;
            dc.drawText(C.cx, C.cy, Graphics.FONT_MEDIUM, msg, Graphics.TEXT_JUSTIFY_CENTER | Graphics.TEXT_JUSTIFY_VCENTER);
        }
    }
}

// Called when this View is removed from the screen. Save the
// state of this View here. This includes freeing resources from
// memory.
function onHide() as Void
{

    L.dbg_log(L.DBG_LIFE, "FlickView.onHide()");
}

function sh_devs()
{

L.dbg_log(L.DBG_LIFE, "sh_devs:" + C.outlets.size());
    C.dev_list = new DevicesMenu();
    for (var i = 0; i < C.outlets.size(); i += 1) {
        C.dev_list.addItem(new DeviceItem(i));
    }
    C.enumerating = C.OUTLET_TPLINK;
    if (C.outlets.size() <= 0) {
        C.state = C.MAIN_WAIT;
        C.set_alert("No devices", "tap to scan");
        WatchUi.requestUpdate();
    } else {
        C.state = C.MAIN_SHOW;
        WatchUi.pushView(C.dev_list, new DeviceDelegate(), WatchUi.SLIDE_UP);
    }
}

public function device_list()
{
    var outlet;

    C.set_alert(null, null);

    if (!C.settings["offline"]) {
        for (var i = C.outlets.size() - 1; i >= 0; i -= 1) {
            outlet = C.outlets[i];
            if (outlet["state"] == G.STATE_OFL) {
                C.outlets.remove(outlet); }
        }
    }
    C.outlet_sort(C.settings["sort_dir"]);
    C.save_devs(null);
    sh_devs();
}

function enumerate(type, msg)
{

    //L.dbg_log(L.DBG_LIFE, "enumerate:" + type + "-" + msg);
    if (type != C.OUTLET_ERROR) {
        C.enumerating = type + 1; }

    switch (type) {

    case C.OUTLET_TPLINK:
        if (C.tplink.avail()) {
            C.set_alert("TpLink", "Enumerating");
            C.dev_ctrl(C.CTRL_ENUMERATE, { "type" => C.OUTLET_TPLINK }, 0, method(:enumerate));
            break;
        }
        // fall thru
    case C.OUTLET_SHELLY:
        if (C.shelly.avail()) {
            C.set_alert("Shelly", "Enumerating");
            C.dev_ctrl(C.CTRL_ENUMERATE, { "type" => C.OUTLET_SHELLY }, 0, method(:enumerate));
            break;
        }
        // fall thru
    case C.OUTLET_ATHOME:
        if (C.athome.avail()) {
            C.set_alert("AtHome", "Enumerating");
            C.dev_ctrl(C.CTRL_ENUMERATE, { "type" => C.OUTLET_ATHOME }, 0, method(:enumerate));
            break;
        }
        // fall thru
    case C.OUTLET_HUUM:
        if (C.huum.avail()) {
            C.set_alert("Huum", "Enumerating");
            C.dev_ctrl(C.CTRL_ENUMERATE, { "type" => C.OUTLET_HUUM }, 0, method(:enumerate));
            break;
        }
        // fall thru
    case C.OUTLET_NONE:
        L.dbg_log(L.DBG_BASIC, "Enumerated");
        device_list();
        break;

    case C.OUTLET_ERROR:
        L.dbg_log(L.DBG_BASIC, "Communications error:" + msg);
        C.state = C.MAIN_ERROR;
        C.set_alert(null,  msg + "\nTap to continue");
        break;

    }
}

}

class FlickDelegate extends WatchUi.BehaviorDelegate {

function initialize()
{

    L.dbg_log(L.DBG_LIFE, "FlickDelegate.initialize()");
    BehaviorDelegate.initialize();
}

function onNextPage() as Boolean
{

    L.dbg_log(L.DBG_LIFE, "FlickDelegate.onNextPage()");
    return true;
}

function onPreviousPage() as Boolean
{

    L.dbg_log(L.DBG_LIFE, "FlickDelegate.onPreviousPage()");
    return true;
}

function onMenu() as Boolean
{

    L.dbg_log(L.DBG_LIFE, "FlickDelegate.onMenu()");
    if (C.state == C.MAIN_LOG) {
        C.state = C.MAIN_WAIT;
    } else {
        C.state = C.MAIN_LOG;
    }
    WatchUi.requestUpdate();
    return true;
}

function onSelect() as Boolean
{

    L.dbg_log(L.DBG_LIFE, "FlickDelegate.onSelect()");
    C.state = C.MAIN_ENUMERATE;
    WatchUi.requestUpdate();
    return true;
}

}

class FlickApp extends Application.AppBase
{

function initialize() {
    AppBase.initialize();
}

// onStart() is called on application start up
function onStart(state as Dictionary?) as Void {
}

// onStop() is called when your application is exiting
function onStop(state as Dictionary?) as Void {
}

(:glance)
function getGlanceView() {
    var view = new GlanceView();
    return [ view ];
}

// Return the initial view of your application here
function getInitialView() as [Views] or [Views, InputDelegates] {
    return [ new FlickView(), new FlickDelegate() ];
}

}

function getApp() as FlickApp {
    return Application.getApp() as FlickApp;
}
