import Toybox.Graphics;
import Toybox.Lang;
import Toybox.System;
import Toybox.WatchUi;

class DevicesMenu extends WatchUi.CustomMenu
{

public function initialize()
{

    CustomMenu.initialize(70, G.BLACK, {});
}

public function drawTitle(dc as Dc)
{

    dc.setColor(Graphics.COLOR_DK_GRAY, Graphics.COLOR_DK_GRAY);
    dc.setPenWidth(3);
    dc.drawLine(0, dc.getHeight() - 2, dc.getWidth(), dc.getHeight() - 2);
    dc.setPenWidth(1);
    dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_TRANSPARENT);
    dc.drawText(dc.getWidth() / 2, dc.getHeight() / 2, Graphics.FONT_LARGE, "Devices", Graphics.TEXT_JUSTIFY_CENTER | Graphics.TEXT_JUSTIFY_VCENTER);
}

}

class DeviceItem extends WatchUi.CustomMenuItem
{

private var id as Number;

public function initialize(id as Number)
{
    CustomMenuItem.initialize(id, {});
    me.id = id;
}

public function draw(dc as Dc) as Void {
    var font = Graphics.FONT_SMALL;
    var dev = C.outlets[id];
    var label = dev["name"];
    var bitm = WatchUi.loadResource(G.get_icon(dev["icon"], dev["state"], G.icons_sm));
    var bm_xy = (dc.getHeight()/2) + - (bitm.getWidth()/2);

    if (dev["ood"] && (dev["state"] != G.STATE_OFL)) {
        dc.drawBitmap(bm_xy, bm_xy, WatchUi.loadResource(G.get_ood(0))); }
    dc.drawBitmap(bm_xy, bm_xy, bitm);

    dc.setColor(Graphics.COLOR_WHITE, Graphics.COLOR_TRANSPARENT);
    dc.drawText(dc.getHeight(), dc.getHeight() / 2, font, label, Graphics.TEXT_JUSTIFY_LEFT | Graphics.TEXT_JUSTIFY_VCENTER);
}

}

class DeviceDelegate extends WatchUi.Menu2InputDelegate
{

function initialize() {
    Menu2InputDelegate.initialize();
}

function onSelect(item as MenuItem)
{

    var idx = (item.getId() as Number).toNumber();;
//L.dbg_log(L.DBG_LIFE, "DeviceDelegate.onSelect:" + idx);
    WatchUi.pushView(new Onoff(idx), new OnoffDelegate(idx), WatchUi.SLIDE_UP);
}

function onBack()
{

    //L.dbg_log(L.DBG_LIFE, "DeviceDelegate.onBack()");
    C.state = C.MAIN_WAIT;
    WatchUi.popView(WatchUi.SLIDE_DOWN);
}

}
